unit UWatek;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

const cMAX  = 10;
const cWAIT = 100;

type

MWatek = class(TThread)
private
   Memo            : TMemo;	// tylko wskanik, nie usuwa
   Panel           : TPanel;	// tylko wskanik, nie usuwa
   wykonuj         : Boolean;
   cyfra           : Integer;
   numer_watku     : Integer;
   MyMutex         : Cardinal;

	procedure   Display();
	procedure   Counter();

protected
	procedure   Execute(); override;

public

	constructor Create(CreateSuspended : Boolean;
                      parMemo         : TMemo;
                      parPanel        : TPanel;
                      parNumer_watku  : Integer;
                      parMyMutex      : Cardinal);

end;

implementation
{------------------------------------------------------------------------------}
constructor MWatek.create(CreateSuspended : Boolean;
                          parMemo         : TMemo;
                          parPanel        : TPanel;
                          parNumer_watku  : Integer;
                          parMyMutex      : Cardinal);

begin
	inherited Create(CreateSuspended);

   Memo            := parMemo;
   wykonuj         := true;
   cyfra           := 1;
   numer_watku     := parNumer_watku;
   Panel           := parPanel;

   FreeOnTerminate := true;

   MyMutex         := parMyMutex;
end;

procedure MWatek.Display();
begin
   Panel.Caption := IntToStr(cyfra);
   Memo.Lines.Add(IntToStr(numer_watku) + '.' + IntToStr(cyfra));
end;

procedure MWatek.Counter();
begin
	Inc(cyfra);
end;

procedure MWatek.Execute();
begin
   if WaitForSingleObject(MyMutex, INFINITE) = WAIT_OBJECT_0 then
   begin
      while wykonuj do
      begin
         Synchronize(Display);
         Synchronize(Counter);

         if (Terminated and (cyfra >= cMAX)) then
         begin
            wykonuj := false;
         end;

         Sleep(cWAIT);
      end;

      Synchronize(Display);

      ReleaseMutex(MyMutex);
   end;
end;

end.

